<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

get_header();
?>

<?php while ( have_posts() ) : the_post(); ?>



<div class="breadcrumbs">
    <div class="wrap">
        <div class="wrap_float">
            <a href="<?php echo get_site_url(); ?>">Home</a>
            <span class="separator">/</span>
            <a href="<?php echo get_site_url(); ?>/blog">Blog</a>
            <span class="separator">/</span>
            <?php the_title(); ?>
        </div>
    </div>
</div>
<div class="page blog-list-page blog-single-page right-sidebar">
  <div class="wrap">
      <div class="wrap_float">
          <div class="page_body">
              <div class="left_content">
                  <div class="blog_single-head">
                      <div class="blog_single-head_top" style="background-image: url(<?php echo get_the_post_thumbnail_url( $post_id, 'large' ); ?>)">
                          <div class="tags">
                            <?php if(get_field('most_popular')): ?>
                              <div class="tag green">
                                  Most Popular
                              </div>
                            <?php endif; ?>
                          </div>
                          <h1 class="title"><?php the_title(); ?></h1>
                      </div>
                  </div>
                  <div class="blog_single-body">
                    <?php the_content(); ?>
                  </div>
                  
                  
              </div>
              <div class="right_content sidebar">
                  <div class="_block">
                      <h4 class="block_title">
                          Popular travel
                      </h4>
                      <div class="popular">
                          <a href="tour-page-right-sidebar.html" class="item">
                              <div class="item_top">
                                  <div class="img" style="background-image: url(img/demo-bg.jpg)"></div>
                                  <h5 class="_title">
                                      A trip to the mighty desert
                                  </h5>
                              </div>
                              <div class="item_bottom">
                                  <div class="days">5 days |</div>
                                  <div class="cost">from $356</div>
                              </div>
                          </a>

                          <a href="tour-page-right-sidebar.html" class="item">
                              <div class="item_top">
                                  <div class="img" style="background-image: url(img/demo-bg.jpg)"></div>
                                  <h5 class="_title">
                                      Antelope canyon in Arizona USA exclusive tour
                                  </h5>
                              </div>
                              <div class="item_bottom">
                                  <div class="days">5 days |</div>
                                  <div class="cost">from $356</div>
                              </div>
                          </a>

                          <a href="tour-page-right-sidebar.html" class="item">
                              <div class="item_top">
                                  <div class="img" style="background-image: url(img/demo-bg.jpg)"></div>
                                  <h5 class="_title">
                                      Asia
                                  </h5>
                              </div>
                              <div class="item_bottom">
                                  <div class="days">5 days |</div>
                                  <span class="sale">-23%</span>
                                  <div class="cost">from $356</div>
                              </div>
                          </a>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
<div class="blog">
  <div class="wrap">
      <div class="wrap_float">
          <div class="title_wrap">
              <h2 class="title">Recent Blog Posts</h2>
              <div class="controls">
                  <a href="<?php echo get_site_url(); ?>/blog" class="link">All Blog Posts</a>
              </div>
          </div>
          <div class="section_content">
              <?php 
                $recent_posts = wp_get_recent_posts(array(
                  'numberposts' => 3, // Number of recent posts thumbnails to display
                  'post_status' => 'publish' // Show only the published posts
                ));
              ?>
              <?php foreach($recent_posts as $post) : ?>
              <a href="<?php echo get_permalink($post['ID']) ?>" class="blog_item">
                  <div class="blog_item_top" style="background-image: url(<?php echo get_the_post_thumbnail_url($post['ID'], 'medium'); ?>);">
                      <div class="sq_parent">
                          <div class="sq_wrap">
                              <div class="sq_content">
                                  <div class="tags">
                                      <div class="tag green">Countries</div>
                                  </div>
                                  <h3 class="_title"><?php echo $post['post_title'] ?></h3>
                              </div>
                          </div>
                      </div>
                      <div class="shadow js-shadow"></div>
                  </div>
                  <div class="blog_item_bottom">
                      <p class="text">
                          Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque
                      </p>
                  </div>
              </a>
              <?php endforeach; wp_reset_query(); ?>
          </div>
      </div>
  </div>
</div>



<?php endwhile; ?>

<?php
get_footer();
